define([
    'backbone',
    'Layout',
    'modules/notifications/notification-list-item-view',
],
function(Backbone, Layout, NotificationsListItem) {
    'use strict';
    
    // TODO these vars should not be here... they in the wrong scope
    var layout = new Layout();
    layout.render();

    describe('Notifications List', function() {

        it("styles the list item with 'unread' class when the readFlag property is set to false", function() {
            var model = new Backbone.Model({
                readFlag: false,
                title: 'Test title',
                source: 'Test source',
            });

            var listItem = new NotificationsListItem({model: model});

            layout.showChildView('content', listItem);

            expect(listItem.$el.find('.unread').size()).toEqual(1);
        });

        it("does not style the list item with 'unread' class when the readFlag property is set to true", function() {
            var model = new Backbone.Model({
                readFlag: true,
                title: 'Test title',
                source: 'Test source',
            });

            var listItem = new NotificationsListItem({model: model});

            layout.showChildView('content', listItem);

            expect(listItem.$el.find('.unread').size()).toEqual(0);
        });
    });

});
